// CameraRemote.cpp : implementation file
//

#include "stdafx.h"
#include "sc510.h"
#include "sc510Dlg.h"
#include "CameraRemote.h"
#include "afxdialogex.h"


// CameraRemote dialog

IMPLEMENT_DYNAMIC(CameraRemote, CDialogEx)

CameraRemote::CameraRemote(CWnd* pParent /*=NULL*/)
	: CDialogEx(CameraRemote::IDD, pParent)
{

}

CameraRemote::~CameraRemote()
{
}

void CameraRemote::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CameraRemote, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_UP, &CameraRemote::OnBnClickedButtonUp)
	ON_BN_CLICKED(IDC_BUTTON_LEFT, &CameraRemote::OnBnClickedButtonLeft)
	ON_BN_CLICKED(IDC_BUTTON_RIGHT, &CameraRemote::OnBnClickedButtonRight)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, &CameraRemote::OnBnClickedButtonDown)
	ON_BN_CLICKED(IDC_BUTTON_SUBMIT, &CameraRemote::OnBnClickedButtonSubmit)
	ON_BN_CLICKED(IDC_BUTTON_OSD_OPEN, &CameraRemote::OnBnClickedButtonOsdOpen)
END_MESSAGE_MAP()


// CameraRemote message handlers


void CameraRemote::OnBnClickedButtonUp()
{
	// TODO: Add your control notification handler code here
	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	BYTE CommandData[8] = { 0xB5, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00 };

	CommandData[7] = (BYTE)( CommandData[0] + CommandData[1] + CommandData[2] + CommandData[3] + CommandData[4] + CommandData[5] + CommandData[6] );
	
	char psz[128];

	sprintf(psz, " sizeof %u - %u  = %u \n", sizeof(CommandData), (UINT)CommandData[7]);

	OutputDebugString(psz);
	

	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 810, CommandData, 16);
}

void CameraRemote::OnBnClickedButtonDown()
{
	// TODO: Add your control notification handler code here
	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	BYTE CommandData[8] = { 0xB5, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00 };

	CommandData[7] = (BYTE)( CommandData[0] + CommandData[1] + CommandData[2] + CommandData[3] + CommandData[4] + CommandData[5] + CommandData[6] );
	
	char psz[128];

	sprintf(psz, " sizeof %u - %u  = %u \n", sizeof(CommandData), (UINT)CommandData[7]);

	OutputDebugString(psz);

	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 810, CommandData, 16);
}

void CameraRemote::OnBnClickedButtonLeft()
{
	// TODO: Add your control notification handler code here
	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	BYTE CommandData[8] = { 0xB5, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00 };

	CommandData[7] = (BYTE)( CommandData[0] + CommandData[1] + CommandData[2] + CommandData[3] + CommandData[4] + CommandData[5] + CommandData[6] );

	char psz[128];

	sprintf(psz, " sizeof %u - %u  = %u \n", sizeof(CommandData), (UINT)CommandData[7]);

	OutputDebugString(psz);

	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 810, CommandData, 16);
}


void CameraRemote::OnBnClickedButtonRight()
{
	// TODO: Add your control notification handler code here
	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	BYTE CommandData[8] = { 0xB5, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 };

	CommandData[7] = (BYTE)( CommandData[0] + CommandData[1] + CommandData[2] + CommandData[3] + CommandData[4] + CommandData[5] + CommandData[6] );

	char psz[128];

	sprintf(psz, " sizeof %u - %u  = %u \n", sizeof(CommandData), (UINT)CommandData[7]);

	OutputDebugString(psz);

	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 810, CommandData, 16);
}


void CameraRemote::OnBnClickedButtonSubmit()
{
	// TODO: Add your control notification handler code here
}


void CameraRemote::OnBnClickedButtonOsdOpen()
{
	// TODO: Add your control notification handler code here
	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	BYTE CommandData[8] = { 0xB5, 0x00, 0x17, 0x5F, 0x00, 0x00, 0x00 };

	CommandData[7] = (BYTE)( CommandData[0] + CommandData[1] + CommandData[2] + CommandData[3] + CommandData[4] + CommandData[5] + CommandData[6] );

	char psz[128];

	sprintf(psz, " sizeof %u - %u  = %u \n", sizeof(CommandData), (UINT)CommandData[7]);

	OutputDebugString(psz);	

	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 810, CommandData, 16);

}
